	function bitspec = pipedelay(bitspec)
	%bitspec = pipedelay(bitspec)
	%
	%Calculates pipeline delay for the branches
	%
	%Arguments:
	%  bitspec - structure:
	%    branches{k}:
	%      ppspec: partial product specification
	%      csspec: reduction tree specification
	%      vmaspec: VMA specification
	%
	%Returns:
	%  bitspec - added fields:
	%    branches{k}:
	%      pipedelay: total delay (structural and pipeline)
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	for b = 1:bitspec.numout
		branch = bitspec.branches{b};
	
		branch.pipedelay = csdelay(branch.csspec) + csdelay(branch.vmaspec) - branch.ppspec.strucdelay;
	
		bitspec.branches{b} = branch;
	end
	
